#include "wifi_driver_main.h"
#include "common_api.h"
#include "wifi_env.h"

// The WLAN driver task priority is set to the next highest priority (0 is highest priority)
// because blockForResponse() needs to temporarily boost caller task's priority
// over that of the driver task
#define ATHEROS_TASK_PRIORITY ((configMAX_PRIORITIES)-2)
#define ATHEROS_TASK_STACKSIZE 1000
TaskHandle_t atheros_wifi_task_id = NULL;
extern void Atheros_Driver_Task(void *pCxt);

/* NOTE: the whole file will be included as part of freertos env */
/* TODO: check stackSize/sizeof(portSTACK_TYPE) */
uint16_t atheros_wifi_task_prio = ATHEROS_TASK_PRIORITY;

A_STATUS Driver_CreateThread(void *pCxt)
{
    BaseType_t status;
    assert(atheros_wifi_task_id == NULL);

    status = xTaskCreate(Atheros_Driver_Task, "Atheros_Wifi_Task", ATHEROS_TASK_STACKSIZE, pCxt, ATHEROS_TASK_PRIORITY,
                         &atheros_wifi_task_id);
    return pdPASS == status ? A_OK : A_ERROR; 
}

// Compliments CreateDriverThread
A_STATUS
Driver_DestroyThread(void *pCxt)
{
    GET_DRIVER_COMMON(pCxt)->driverShutdown = true;
    DRIVER_WAKE_DRIVER(pCxt);
    return A_OK;
}
